
*/ This file creates the merged file based on rematching the rural and the city files. */

***** SET PATH NAME AS APPROPRIATE FOR YOUR COMPUTER;

libname rama 'C:\Rama\FinalfilesforPRC';

data rama.city;
 	set rama.city0;
/*totcost=delvcost+nondcost;
variblty=vardcost/delvcost;
profit=revenue-totcost;*/
 city=1;
 run;
* Rematch variables in rural with variables in city- added profit; 

data rama.rural(rename=(FCSPLV= D2 FCPSV= D3 FCSPCV= D4 FCPSCV= D5
PRIV= D7 EXPV= D8 PERV= D10 SMECRV =D16 SMREGV= d17 PPV= D23
BPMV= D24 MLV = D25 USPSV= D28 FREEV= D29 INTLV=D41
TBOXES=posdelv TPCS=volume  VDC_R = vardcost FDC_R = fxddcost ndc_r= nondcost tc_r= totcost 
tr_r=revenue pf_r= profit VARIABILITY= variblty));
	set rama.rmc_06;

	*The city weight is the daily blow-up factor annualized, then put into thousands.; 
	*Finally, it must be multiplied by ten because the city data are sampled at every
	tenth stop, and their data have been multiplied by 10 to bring their volumes to the route level
	and be comparable to rural volumes.

	When the city weight is applied in the EP Model it  must be divided by 10, since the original weight 
	is appropriate for this purpose, but the city volumes have been multiplied by 10.  Dividing the city
	weight by 10 will make the final city revenue and cost values correct.
	However, in that file, the variable wgt applies to both city and rural routes.
	Since rural volumes were already at the route level, they were not multiplied by 10.
	So when the wgt is divided by 10, the rural wgt must be created that multiplies by 10 
	in order to have the appropriate rural weight applied;

	* 75664= total nr of rural routes
	 73144= size of the sample of rural routes
	 302= nr of days per year delivered mail- changed from 303 in 1999
	The formula for the rural weight is:  (1/ sample ratio)*10*302(full year)/1000;
run;

	data rama.rural;
		set rama.rural;

	city = 0;
	wgt = (75664/73144)*(302/1000)*10;
	/*delvcost = vardcost+fxddcost;*/

	*A rural rtwgt is created to gross up rural evaluated routes to the universe
     of rural routes.  Formula is (Universe of routes/Evaluateed Routes)
	 or (75664/73144), which = 1.03444575;

	rtwgt = 1.0344452586;
	
	
data rama.merged;
	set rama.city rama.rural;
run;

data rama.merged1 (keep= profit city testid stratum rtwgt wgt busdelv resdelv posbus posres
d2 d3 d4 d5 d7 d8 d10 d16 d17 d23 d24 d25 d28 d29 d41 
rev2 rev3 rev4 rev5 rev7 rev8 rev10 rev16 rev17 rev23 rev24 rev25 rev28 rev29 rev41 
vdc2 vdc3 vdc4 vdc5 vdc7 vdc8 vdc10 vdc16 vdc17 vdc23 vdc24 vdc25 vdc28 vdc29 vdc41 
ndc2 ndc3 ndc4 ndc5 ndc7 ndc8 ndc10 ndc16 ndc17 ndc23 ndc24 ndc25 ndc28 ndc29 ndc41 
delvcost nondcost vardcost totcost revenue cag  rcat totdelv posdelv volume  fxddcost variblty);

	set rama.merged;

* ADDED stratum rtwgt qtr
busdelv resdelv posbus posres
for the EP model;

* unit revenue per route (Dollars/per piece) from Calculations 2007.xls, worksheet Revenue per piece, 
transformed in Matching_rural_city.xls worksheet buckets_URevenue;
* originally from "Calculation of Revenue and Non-Delivery Cost per piece by Subclass", 
* Docket No. ACR2007-1, Library Reference PRC-ACR2007-LR1, 07 Revenue_Fees_LR1.xls, Worksheet "All_R";

        rev2=d2*0.49284;
        rev3=d3*0.33026;
        rev4=d4*0.26006;
        rev5=d5*0.19827;
        rev7=d7*5.83566;
        rev8=d8*17.35771;
        rev10=d10*0.24875;
        rev16= d16*0.17428;
        rev17= d17*0.21418;
        rev23=d23*3.46544;
        rev24=d24*1.08308;
        rev25=d25*2.30393;
        rev28=d28*0.00000;
        rev29=d29*0.00000;
        rev41=d41*2.44514;


        revenue= sum(rev2,rev3,rev4,rev5,rev7,rev8,rev10,rev16,rev17,
        rev23,rev24,rev25,rev28,rev29,rev41);

* unit variable delivery cost for city is unit delivery cost(dollars/piece/ per route). I used delivery cost
calculated as the sum of piggybacked unit delivery cost for city and piggybacked
unit delivery cost for rural;
* from Calculations_2007.xls, worksheet Non delivery unit attributable, transformed in
Matching_rural_city.xls worksheet buckets_Udeliverycost;

        vdc2=d2* 0.09002;
        vdc3=d3*0.04288;
        vdc4=d4*0.09644;
        vdc5=d5*0.03736;
        vdc7=d7*0.36529;
        vdc8=d8*1.4407;
        vdc10=d10*0.09306;
        vdc16=d16*0.06091;
        vdc17=d17*0.05515;
        vdc23=d23*0.47284;
        vdc24=d24*0.26043;
        vdc25=d25*0.36714;
        vdc28=d28*0.07572;
        vdc29=d29*0.18878;
        vdc41=d41*0.08501;

        vardcost=sum(vdc2,vdc3,vdc4,vdc5,vdc7,vdc8,vdc10,vdc16,vdc17,
        vdc23,vdc24,vdc25,vdc28,vdc29,vdc41);

* Unit Non delivery costs (dollars/piece/route. From Calculations 2007.xls, worksheet Revenue per piece
(also, worksheet Non delivery unit atrributable- in cents);

        ndc2=d2*0.21946;
        ndc3=d3*0.07532;
        ndc4=d4*0.14080;
        ndc5=d5*0.04026;
        ndc7=d7*4.16058;
        ndc8=d8*9.66578;
        ndc10=d10*0.20661;
        ndc16=d16*0.03058;
        ndc17=d17*0.08997;
        ndc23=d23*2.88022;
        ndc24=d24*0.68392;
        ndc25=d25*2.15427;
        ndc28=d28*0.40445;
        ndc29=d29*0.70417;
        ndc41=d41*2.05256;

        nondcost= sum(ndc2,ndc3,ndc4,ndc5,ndc7,ndc8,ndc10,ndc16,ndc17,
        ndc23,ndc24,ndc25,ndc28,ndc29,ndc41);


        volume=sum(d2,d3,d4,d5,d7,d8,d10,d16,d17,d23,d24,d25,d28,
        d29,d41);

		if rcat=1 or rcat=2 then delvcost=494.45;
        else delvcost= 409.32;
       	if delvcost<vardcost and city=1 then fxddcost=0;
        if delvcost>=vardcost and city=1 then fxddcost=delvcost-vardcost;

		if city=0 then delvcost= fxddcost + vardcost;
        totcost=nondcost+delvcost;
		* totcost= total attributable cost- 
		there is an attributable cost= var cost+nondcost in 
		Calculations 2007.xls, worksheet Nondelivery unit attributable;
        profit=revenue-totcost;
        variblty=vardcost/delvcost;

run;



proc sort data= rama.merged1;
	by profit;
 run;

proc means data = rama.merged1;
var profit city testid rtwgt wgt  busdelv resdelv posbus posres
d2 d3 d4 d5 d7 d8 d10 d16 d17 d23 d24 d25 d28 d29 d41 
rev2 rev3 rev4 rev5 rev7 rev8 rev10 rev16 rev17 rev23 rev24 rev25 rev28 rev29 rev41 
vdc2 vdc3 vdc4 vdc5 vdc7 vdc8 vdc10 vdc16 vdc17 vdc23 vdc24 vdc25 vdc28 vdc29 vdc41 
ndc2 ndc3 ndc4 ndc5 ndc7 ndc8 ndc10 ndc16 ndc17 ndc23 ndc24 ndc25 ndc28 ndc29 ndc41 
delvcost nondcost vardcost totcost revenue rcat totdelv posdelv volume  fxddcost variblty;

output out = totals mean = profit city testid rtwgt wgt busdelv resdelv posbus posres
d2 d3 d4 d5 d7 d8 d10 d16 d17 d23 d24 d25 d28 d29 d41 
rev2 rev3 rev4 rev5 rev7 rev8 rev10 rev16 rev17 rev23 rev24 rev25 rev28 rev29 rev41 
vdc2 vdc3 vdc4 vdc5 vdc7 vdc8 vdc10 vdc16 vdc17 vdc23 vdc24 vdc25 vdc28 vdc29 vdc41 
ndc2 ndc3 ndc4 ndc5 ndc7 ndc8 ndc10 ndc16 ndc17 ndc23 ndc24 ndc25 ndc28 ndc29 ndc41 
delvcost nondcost vardcost totcost revenue rcat totdelv posdelv volume  fxddcost variblty;


run;

proc print data = totals;
title 'Means and Sums of mergedEP Variables Larrys Version';
run;
